<?php
/**
 * Template part for displaying default header layout
 */
$header_full = consultio_get_opt( 'header_full', false );
$sticky_on = consultio_get_opt( 'sticky_on', false );
$search_icon = consultio_get_opt( 'search_icon', false );
$cart_icon = consultio_get_opt( 'cart_icon', false );
$wellcome = consultio_get_opt( 'wellcome', '' );
$h_address = consultio_get_opt( 'h_address', '' );
$h_address_label = consultio_get_opt( 'h_address_label', '' );
$h_phone = consultio_get_opt( 'h_phone', '' );
$h_phone_label = consultio_get_opt( 'h_phone_label', '' );
$h_phone_link = consultio_get_opt( 'h_phone_link', '' );
$h_phone_link_target = consultio_get_opt( 'h_phone_link_target', '_self' );
$h_address_link = consultio_get_opt( 'h_address_link', '' );
$h_address_link_target = consultio_get_opt( 'h_address_link_target', '_self' );
$h_time = consultio_get_opt( 'h_time', '' );
$h_time_label = consultio_get_opt( 'h_time_label', '' );

$h_btn_on = consultio_get_opt( 'h_btn_on', 'hide' );
$h_btn_text = consultio_get_opt( 'h_btn_text' );
$h_btn_link_type = consultio_get_opt( 'h_btn_link_type', 'page' );
$h_btn_link = consultio_get_opt( 'h_btn_link' );
$h_btn_link_custom = consultio_get_opt( 'h_btn_link_custom' );
$h_btn_target = consultio_get_opt( 'h_btn_target', '_self' );
if($h_btn_link_type == 'page') {
    $h_btn_url = get_permalink($h_btn_link);
} else {
    $h_btn_url = $h_btn_link_custom;
}
$logo_mobile = consultio_get_opt( 'logo_mobile', array( 'url' => get_template_directory_uri().'/assets/images/logo-dark.png', 'id' => '' ) );
$custom_header = consultio_get_page_opt('custom_header');
$p_logo_mobile = consultio_get_page_opt('p_logo_mobile');
if($custom_header && !empty($p_logo_mobile['url'])) {
    $logo_mobile['url'] = $p_logo_mobile['url'];
}
?>
<header id="ct-masthead">
    <div id="ct-header-wrap" class="ct-header-layout18 fixed-height <?php if($sticky_on == 1) { echo 'is-sticky'; } ?> <?php if($header_full == 1) { echo 'is-full-header'; } ?>">
        
        <div id="ct-header-top" class="ct-header-top9">
            <div class="container">
                <div class="row">
                    <?php if(!empty($wellcome)) : ?>
                        <div class="ct-header-wellcome">
                            <?php echo wp_kses_post($wellcome); ?>
                        </div>
                    <?php endif; ?>
                    <div class="ct-header-social">
                        <?php consultio_social_header(); ?>
                    </div>
                </div>
            </div>
        </div>
        
        <div id="ct-header-middle">
            <div class="container">
                <div class="row">
                    <div class="ct-header-branding">
                        <?php get_template_part( 'template-parts/header-branding' ); ?>
                    </div>
                    <div class="ct-header-holder style-two">
                        <?php if(!empty($h_phone)) : ?>
                            <div class="ct-header-info-item ct-header-call">
                                <div class="h-item-icon">
                                    <svg width="60px" height="60px" enable-background="new 0 0 512.076 512.076" version="1.1" viewBox="0 0 512.08 512.08" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
                                        <path d="m499.64 396.04-103.65-69.12c-13.153-8.701-30.784-5.838-40.508 6.579l-30.191 38.818c-3.88 5.116-10.933 6.6-16.546 3.482l-5.743-3.166c-19.038-10.377-42.726-23.296-90.453-71.04s-60.672-71.45-71.049-90.453l-3.149-5.743c-3.161-5.612-1.705-12.695 3.413-16.606l38.792-30.182c12.412-9.725 15.279-27.351 6.588-40.508l-69.12-103.65c-8.907-13.398-26.777-17.42-40.566-9.131l-43.341 26.035c-13.618 8.006-23.609 20.972-27.878 36.181-15.607 56.866-3.866 155.01 140.71 299.6 115 115 200.62 145.92 259.46 145.92 13.543 0.058 27.033-1.704 40.107-5.239 15.212-4.264 28.18-14.256 36.181-27.878l26.061-43.315c8.301-13.792 4.281-31.673-9.123-40.585zm-5.581 31.829-26.001 43.341c-5.745 9.832-15.072 17.061-26.027 20.173-52.497 14.413-144.21 2.475-283.01-136.32s-150.73-230.5-136.32-283.01c3.116-10.968 10.354-20.307 20.198-26.061l43.341-26.001c5.983-3.6 13.739-1.855 17.604 3.959l37.547 56.371 31.514 47.266c3.774 5.707 2.534 13.356-2.85 17.579l-38.801 30.182c-11.808 9.029-15.18 25.366-7.91 38.332l3.081 5.598c10.906 20.002 24.465 44.885 73.967 94.379 49.502 49.493 74.377 63.053 94.37 73.958l5.606 3.089c12.965 7.269 29.303 3.898 38.332-7.91l30.182-38.801c4.224-5.381 11.87-6.62 17.579-2.85l103.64 69.12c5.818 3.862 7.563 11.622 3.958 17.604z"/>
                                        <path d="m291.16 86.39c80.081 0.089 144.98 64.986 145.07 145.07 0 4.713 3.82 8.533 8.533 8.533s8.533-3.82 8.533-8.533c-0.099-89.503-72.63-162.04-162.13-162.13-4.713 0-8.533 3.82-8.533 8.533s3.82 8.533 8.533 8.533z"/>
                                        <path d="m291.16 137.59c51.816 0.061 93.806 42.051 93.867 93.867 0 4.713 3.821 8.533 8.533 8.533 4.713 0 8.533-3.82 8.533-8.533-0.071-61.238-49.696-110.86-110.93-110.93-4.713 0-8.533 3.82-8.533 8.533s3.82 8.533 8.533 8.533z"/>
                                        <path d="m291.16 188.79c23.552 0.028 42.638 19.114 42.667 42.667 0 4.713 3.821 8.533 8.533 8.533s8.533-3.82 8.533-8.533c-0.038-32.974-26.759-59.696-59.733-59.733-4.713 0-8.533 3.82-8.533 8.533s3.82 8.533 8.533 8.533z"/>
                                    </svg>
                                </div>
                                <div class="h-item-meta">
                                    <label><?php echo esc_attr($h_phone_label); ?></label>
                                    <span><?php echo wp_kses_post($h_phone); ?></span>
                                </div>
                                <?php if(!empty($h_phone_link)) : ?>
                                    <a href="tel:<?php echo esc_attr($h_phone_link); ?>" target="<?php echo esc_attr($h_phone_link_target); ?>" class="h-item-link"></a>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>

                        <?php if(!empty($h_time)) : ?>
                            <div class="ct-header-info-item ct-header-time">
                                <div class="h-item-icon">
                                    <svg width="60px" height="60px" enable-background="new 0 0 480.137 480.137" version="1.1" viewBox="0 0 480.14 480.14" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
                                        <path d="m459.06 21.086c-28.185-27.986-73.671-27.986-101.86 0-0.75 0.753-1.343 1.648-1.744 2.632-0.35 0.879-0.537 1.814-0.552 2.76-0.023 0.09-0.042 0.18-0.056 0.272 1e-3 1.046 0.208 2.082 0.608 3.048 0.395 0.981 0.986 1.871 1.736 2.616l39.624 39.624-15.32 15.312c-38.382-35.478-88.725-55.188-140.99-55.2-0.136-0.04-0.24-0.112-0.376-0.112s-0.24 0.072-0.376 0.072c-52.274 0.022-102.62 19.75-140.99 55.248l-15.32-15.32 39.624-39.624c0.75-0.745 1.341-1.635 1.736-2.616 0.4-0.966 0.607-2.002 0.608-3.048 0-0.096-0.048-0.176-0.056-0.272 7e-3 -1.846-0.711-3.622-2-4.944-0.12-0.136-0.16-0.304-0.288-0.432-28.129-28.133-73.739-28.137-101.87-8e-3 -28.134 28.129-28.137 73.739-8e-3 101.87 0.112 0.12 0.272 0.152 0.392 0.264 0.652 0.614 1.404 1.112 2.224 1.472 0.873 0.343 1.799 0.53 2.736 0.552 0.096 0 0.192 0.056 0.296 0.056 1.042-4e-3 2.074-0.208 3.04-0.6 0.979-0.403 1.868-0.995 2.616-1.744l39.64-39.616 15.32 15.32c-78.008 84.328-72.885 215.93 11.442 293.93 7.209 6.668 14.88 12.818 22.958 18.402l-55.384 55.376c-3.178 3.069-3.266 8.134-0.196 11.312 3.069 3.178 8.134 3.266 11.312 0.196 0.067-0.064 0.132-0.13 0.196-0.196l57.896-57.896c64.542 37.654 144.35 37.654 208.9 0l57.896 57.896c3.178 3.07 8.242 2.982 11.312-0.196 2.995-3.1 2.995-8.016 0-11.116l-55.384-55.376c94.495-65.369 118.11-194.96 52.737-289.46-5.567-8.047-11.695-15.692-18.337-22.877l15.336-15.32 39.624 39.624c0.748 0.749 1.637 1.341 2.616 1.744 0.966 0.392 1.998 0.596 3.04 0.6 0.104 0 0.2-0.056 0.296-0.056 0.937-0.022 1.863-0.209 2.736-0.552 0.82-0.36 1.572-0.858 2.224-1.472 0.12-0.112 0.28-0.144 0.392-0.264 27.98-28.184 27.959-73.683 0-101.89zm-431.79 84.504c-18.448-24.851-13.258-59.951 11.593-78.4 19.835-14.724 46.972-14.724 66.807 0l-78.4 78.4zm404.52 126.45h-39.656c-4.418 0-8 3.582-8 8s3.582 8 8 8h39.8c-4.277 99.685-84.115 179.52-183.8 183.8v-39.8c0-4.418-3.582-8-8-8s-8 3.582-8 8v39.8c-99.685-4.277-179.52-84.115-183.8-183.8h39.8c4.418 0 8-3.582 8-8s-3.582-8-8-8h-39.656c1.817-47.961 21.617-93.483 55.464-127.51 0.128-0.112 0.288-0.152 0.408-0.272s0.16-0.28 0.272-0.408c34.022-33.858 79.547-53.66 127.51-55.464v39.656c0 4.418 3.582 8 8 8s8-3.582 8-8v-39.656c47.965 1.803 93.491 21.605 127.51 55.464 0.112 0.128 0.152 0.288 0.272 0.408s0.28 0.16 0.408 0.272c33.846 34.03 53.646 79.551 55.464 127.51zm21.192-126.46-78.4-78.4c24.742-18.557 59.843-13.542 78.4 11.2 14.933 19.912 14.933 47.289 0 67.2z"/>
                                        <path d="m353.9 165.11h0.016l-90.992 52.528c-12.287-12.592-32.456-12.839-45.048-0.552-0.186 0.182-0.37 0.366-0.552 0.552l-49.416-28.528c-3.812-2.234-8.713-0.956-10.947 2.856s-0.956 8.713 2.856 10.947c0.03 0.018 0.061 0.035 0.092 0.053l49.496 28.576c-4.964 16.962 4.763 34.736 21.725 39.699 16.962 4.964 34.736-4.763 39.699-21.725 1.717-5.869 1.717-12.106 0-17.975l91.072-52.576c3.812-2.234 5.09-7.136 2.856-10.947-2.215-3.775-7.052-5.071-10.857-2.908zm-113.77 90.928c-8.837 0-16-7.163-16-16s7.163-16 16-16 16 7.163 16 16-7.164 16-16 16z"/>
                                    </svg>
                                </div>
                                <div class="h-item-meta">
                                    <label><?php echo esc_attr($h_time_label); ?></label>
                                    <span><?php echo wp_kses_post($h_time); ?></span>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if(!empty($h_address)) : ?>
                            <div class="ct-header-info-item ct-header-address">
                                <div class="h-item-icon">
                                    <svg width="60px" height="60px" enable-background="new 0 0 480 480" version="1.1" viewBox="0 0 480 480" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
                                        <path d="m240 0c-83.947 0-152 68.053-152 152 0 40.448 26.16 102.1 77.744 183.2l67.504 106.18c2.37 3.729 7.314 4.831 11.043 2.461 0.991-0.63 1.831-1.47 2.461-2.461l67.504-106.18c51.584-81.104 77.744-142.75 77.744-183.2 0-83.947-68.053-152-152-152zm60.76 326.63-60.76 95.552-60.76-95.552c-49.928-78.52-75.24-137.27-75.24-174.63 0.084-75.076 60.924-135.92 136-136 75.076 0.084 135.92 60.924 136 136 0 37.36-25.312 96.112-75.24 174.63z"/>
                                        <path d="m240 80c-39.764 0-72 32.235-72 72 0 36.616 58.568 129.79 65.248 140.3 1.469 2.308 4.016 3.705 6.752 3.704 2.736 1e-3 5.283-1.396 6.752-3.704 6.68-10.504 65.248-103.68 65.248-140.3 0-39.765-32.235-72-72-72zm0 192.85c-20.208-33.128-56-96.8-56-120.85 0.035-30.913 25.087-55.965 56-56 30.913 0.035 55.965 25.087 56 56 0 24.064-35.792 87.72-56 120.85z"/>
                                        <path d="m272.48 408.9-0.912 16c59.112 3.328 84.656 14.16 88.224 19.136-5.016 7.416-47.688 19.968-119.79 19.968s-114.78-12.544-119.79-20c3.568-4.968 29.08-15.792 88.104-19.128l-0.904-16c-31.096 1.792-103.41 8.728-103.41 35.128 0 28.416 85.488 36 136 36s136-7.584 136-36c0-26.4-72.4-33.352-103.52-35.104z"/>
                                        <path d="m240 112c-22.091 0-40 17.909-40 40s17.909 40 40 40c22.08-0.026 39.974-17.92 40-40 0-22.091-17.909-40-40-40zm0 64c-13.255 0-24-10.745-24-24s10.745-24 24-24 24 10.745 24 24-10.745 24-24 24z"/>
                                    </svg>
                                </div>
                                <div class="h-item-meta">
                                    <label><?php echo esc_attr($h_address_label); ?></label>
                                    <span><?php echo wp_kses_post($h_address); ?></span>
                                </div>
                                <?php if(!empty($h_address_link)) : ?>
                                    <a href="<?php echo esc_url($h_address_link); ?>" target="<?php echo esc_attr($h_address_link_target); ?>" class="h-item-link"></a>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <div id="ct-header" class="ct-header-main">
            <div class="container">
                <div class="row">
                    <div class="ct-header-branding">
                        <?php get_template_part( 'template-parts/header-branding' ); ?>
                    </div>
                    <div class="ct-header-navigation">
                        <div class="ct-header-navigation-bg">
                            <nav class="ct-main-navigation">
                                <div class="ct-main-navigation-inner">
                                    <?php if ($logo_mobile['url']) { ?>
                                        <div class="ct-logo-mobile">
                                            <a href="<?php esc_url( esc_url( home_url( '/' ) ) ); ?>" title="<?php esc_attr( get_bloginfo( 'name' ) ); ?>" rel="home"><img src="<?php echo esc_url( $logo_mobile['url'] ); ?>" alt="<?php esc_attr( get_bloginfo( 'name' ) ); ?>"/></a>
                                        </div>
                                    <?php } ?>
                                    <?php consultio_header_mobile_search(); ?>
                                    <?php get_template_part( 'template-parts/header-menu' ); ?>
                                    <div class="ct-header-holder style-two ct-header-holder-mobile">
                                        <?php if(!empty($h_phone)) : ?>
                                            <div class="ct-header-info-item ct-header-call">
                                                <div class="h-item-icon">
                                                    <svg width="60px" height="60px" enable-background="new 0 0 512.076 512.076" version="1.1" viewBox="0 0 512.08 512.08" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="m499.64 396.04-103.65-69.12c-13.153-8.701-30.784-5.838-40.508 6.579l-30.191 38.818c-3.88 5.116-10.933 6.6-16.546 3.482l-5.743-3.166c-19.038-10.377-42.726-23.296-90.453-71.04s-60.672-71.45-71.049-90.453l-3.149-5.743c-3.161-5.612-1.705-12.695 3.413-16.606l38.792-30.182c12.412-9.725 15.279-27.351 6.588-40.508l-69.12-103.65c-8.907-13.398-26.777-17.42-40.566-9.131l-43.341 26.035c-13.618 8.006-23.609 20.972-27.878 36.181-15.607 56.866-3.866 155.01 140.71 299.6 115 115 200.62 145.92 259.46 145.92 13.543 0.058 27.033-1.704 40.107-5.239 15.212-4.264 28.18-14.256 36.181-27.878l26.061-43.315c8.301-13.792 4.281-31.673-9.123-40.585zm-5.581 31.829-26.001 43.341c-5.745 9.832-15.072 17.061-26.027 20.173-52.497 14.413-144.21 2.475-283.01-136.32s-150.73-230.5-136.32-283.01c3.116-10.968 10.354-20.307 20.198-26.061l43.341-26.001c5.983-3.6 13.739-1.855 17.604 3.959l37.547 56.371 31.514 47.266c3.774 5.707 2.534 13.356-2.85 17.579l-38.801 30.182c-11.808 9.029-15.18 25.366-7.91 38.332l3.081 5.598c10.906 20.002 24.465 44.885 73.967 94.379 49.502 49.493 74.377 63.053 94.37 73.958l5.606 3.089c12.965 7.269 29.303 3.898 38.332-7.91l30.182-38.801c4.224-5.381 11.87-6.62 17.579-2.85l103.64 69.12c5.818 3.862 7.563 11.622 3.958 17.604z"/>
                                                        <path d="m291.16 86.39c80.081 0.089 144.98 64.986 145.07 145.07 0 4.713 3.82 8.533 8.533 8.533s8.533-3.82 8.533-8.533c-0.099-89.503-72.63-162.04-162.13-162.13-4.713 0-8.533 3.82-8.533 8.533s3.82 8.533 8.533 8.533z"/>
                                                        <path d="m291.16 137.59c51.816 0.061 93.806 42.051 93.867 93.867 0 4.713 3.821 8.533 8.533 8.533 4.713 0 8.533-3.82 8.533-8.533-0.071-61.238-49.696-110.86-110.93-110.93-4.713 0-8.533 3.82-8.533 8.533s3.82 8.533 8.533 8.533z"/>
                                                        <path d="m291.16 188.79c23.552 0.028 42.638 19.114 42.667 42.667 0 4.713 3.821 8.533 8.533 8.533s8.533-3.82 8.533-8.533c-0.038-32.974-26.759-59.696-59.733-59.733-4.713 0-8.533 3.82-8.533 8.533s3.82 8.533 8.533 8.533z"/>
                                                    </svg>
                                                </div>
                                                <div class="h-item-meta">
                                                    <label><?php echo esc_attr($h_phone_label); ?></label>
                                                    <span><?php echo wp_kses_post($h_phone); ?></span>
                                                </div>
                                                <?php if(!empty($h_phone_link)) : ?>
                                                    <a href="tel:<?php echo esc_attr($h_phone_link); ?>" target="<?php echo esc_attr($h_phone_link_target); ?>" class="h-item-link"></a>
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>

                                        <?php if(!empty($h_time)) : ?>
                                            <div class="ct-header-info-item ct-header-time">
                                                <div class="h-item-icon">
                                                    
                                                    <svg width="60px" height="60px" enable-background="new 0 0 480.137 480.137" version="1.1" viewBox="0 0 480.14 480.14" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="m459.06 21.086c-28.185-27.986-73.671-27.986-101.86 0-0.75 0.753-1.343 1.648-1.744 2.632-0.35 0.879-0.537 1.814-0.552 2.76-0.023 0.09-0.042 0.18-0.056 0.272 1e-3 1.046 0.208 2.082 0.608 3.048 0.395 0.981 0.986 1.871 1.736 2.616l39.624 39.624-15.32 15.312c-38.382-35.478-88.725-55.188-140.99-55.2-0.136-0.04-0.24-0.112-0.376-0.112s-0.24 0.072-0.376 0.072c-52.274 0.022-102.62 19.75-140.99 55.248l-15.32-15.32 39.624-39.624c0.75-0.745 1.341-1.635 1.736-2.616 0.4-0.966 0.607-2.002 0.608-3.048 0-0.096-0.048-0.176-0.056-0.272 7e-3 -1.846-0.711-3.622-2-4.944-0.12-0.136-0.16-0.304-0.288-0.432-28.129-28.133-73.739-28.137-101.87-8e-3 -28.134 28.129-28.137 73.739-8e-3 101.87 0.112 0.12 0.272 0.152 0.392 0.264 0.652 0.614 1.404 1.112 2.224 1.472 0.873 0.343 1.799 0.53 2.736 0.552 0.096 0 0.192 0.056 0.296 0.056 1.042-4e-3 2.074-0.208 3.04-0.6 0.979-0.403 1.868-0.995 2.616-1.744l39.64-39.616 15.32 15.32c-78.008 84.328-72.885 215.93 11.442 293.93 7.209 6.668 14.88 12.818 22.958 18.402l-55.384 55.376c-3.178 3.069-3.266 8.134-0.196 11.312 3.069 3.178 8.134 3.266 11.312 0.196 0.067-0.064 0.132-0.13 0.196-0.196l57.896-57.896c64.542 37.654 144.35 37.654 208.9 0l57.896 57.896c3.178 3.07 8.242 2.982 11.312-0.196 2.995-3.1 2.995-8.016 0-11.116l-55.384-55.376c94.495-65.369 118.11-194.96 52.737-289.46-5.567-8.047-11.695-15.692-18.337-22.877l15.336-15.32 39.624 39.624c0.748 0.749 1.637 1.341 2.616 1.744 0.966 0.392 1.998 0.596 3.04 0.6 0.104 0 0.2-0.056 0.296-0.056 0.937-0.022 1.863-0.209 2.736-0.552 0.82-0.36 1.572-0.858 2.224-1.472 0.12-0.112 0.28-0.144 0.392-0.264 27.98-28.184 27.959-73.683 0-101.89zm-431.79 84.504c-18.448-24.851-13.258-59.951 11.593-78.4 19.835-14.724 46.972-14.724 66.807 0l-78.4 78.4zm404.52 126.45h-39.656c-4.418 0-8 3.582-8 8s3.582 8 8 8h39.8c-4.277 99.685-84.115 179.52-183.8 183.8v-39.8c0-4.418-3.582-8-8-8s-8 3.582-8 8v39.8c-99.685-4.277-179.52-84.115-183.8-183.8h39.8c4.418 0 8-3.582 8-8s-3.582-8-8-8h-39.656c1.817-47.961 21.617-93.483 55.464-127.51 0.128-0.112 0.288-0.152 0.408-0.272s0.16-0.28 0.272-0.408c34.022-33.858 79.547-53.66 127.51-55.464v39.656c0 4.418 3.582 8 8 8s8-3.582 8-8v-39.656c47.965 1.803 93.491 21.605 127.51 55.464 0.112 0.128 0.152 0.288 0.272 0.408s0.28 0.16 0.408 0.272c33.846 34.03 53.646 79.551 55.464 127.51zm21.192-126.46-78.4-78.4c24.742-18.557 59.843-13.542 78.4 11.2 14.933 19.912 14.933 47.289 0 67.2z"/>
                                                        <path d="m353.9 165.11h0.016l-90.992 52.528c-12.287-12.592-32.456-12.839-45.048-0.552-0.186 0.182-0.37 0.366-0.552 0.552l-49.416-28.528c-3.812-2.234-8.713-0.956-10.947 2.856s-0.956 8.713 2.856 10.947c0.03 0.018 0.061 0.035 0.092 0.053l49.496 28.576c-4.964 16.962 4.763 34.736 21.725 39.699 16.962 4.964 34.736-4.763 39.699-21.725 1.717-5.869 1.717-12.106 0-17.975l91.072-52.576c3.812-2.234 5.09-7.136 2.856-10.947-2.215-3.775-7.052-5.071-10.857-2.908zm-113.77 90.928c-8.837 0-16-7.163-16-16s7.163-16 16-16 16 7.163 16 16-7.164 16-16 16z"/>
                                                    </svg>
                                                </div>
                                                <div class="h-item-meta">
                                                    <label><?php echo esc_attr($h_time_label); ?></label>
                                                    <span><?php echo wp_kses_post($h_time); ?></span>
                                                </div>
                                            </div>
                                        <?php endif; ?>

                                        <?php if(!empty($h_address)) : ?>
                                            <div class="ct-header-info-item ct-header-address">
                                                <div class="h-item-icon">
                                                    <svg width="60px" height="60px" enable-background="new 0 0 480 480" version="1.1" viewBox="0 0 480 480" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="m240 0c-83.947 0-152 68.053-152 152 0 40.448 26.16 102.1 77.744 183.2l67.504 106.18c2.37 3.729 7.314 4.831 11.043 2.461 0.991-0.63 1.831-1.47 2.461-2.461l67.504-106.18c51.584-81.104 77.744-142.75 77.744-183.2 0-83.947-68.053-152-152-152zm60.76 326.63-60.76 95.552-60.76-95.552c-49.928-78.52-75.24-137.27-75.24-174.63 0.084-75.076 60.924-135.92 136-136 75.076 0.084 135.92 60.924 136 136 0 37.36-25.312 96.112-75.24 174.63z"/>
                                                        <path d="m240 80c-39.764 0-72 32.235-72 72 0 36.616 58.568 129.79 65.248 140.3 1.469 2.308 4.016 3.705 6.752 3.704 2.736 1e-3 5.283-1.396 6.752-3.704 6.68-10.504 65.248-103.68 65.248-140.3 0-39.765-32.235-72-72-72zm0 192.85c-20.208-33.128-56-96.8-56-120.85 0.035-30.913 25.087-55.965 56-56 30.913 0.035 55.965 25.087 56 56 0 24.064-35.792 87.72-56 120.85z"/>
                                                        <path d="m272.48 408.9-0.912 16c59.112 3.328 84.656 14.16 88.224 19.136-5.016 7.416-47.688 19.968-119.79 19.968s-114.78-12.544-119.79-20c3.568-4.968 29.08-15.792 88.104-19.128l-0.904-16c-31.096 1.792-103.41 8.728-103.41 35.128 0 28.416 85.488 36 136 36s136-7.584 136-36c0-26.4-72.4-33.352-103.52-35.104z"/>
                                                        <path d="m240 112c-22.091 0-40 17.909-40 40s17.909 40 40 40c22.08-0.026 39.974-17.92 40-40 0-22.091-17.909-40-40-40zm0 64c-13.255 0-24-10.745-24-24s10.745-24 24-24 24 10.745 24 24-10.745 24-24 24z"/>
                                                    </svg>
                                                </div>
                                                <div class="h-item-meta">
                                                    <label><?php echo esc_attr($h_address_label); ?></label>
                                                    <span><?php echo wp_kses_post($h_address); ?></span>
                                                </div>
                                                <?php if(!empty($h_address_link)) : ?>
                                                    <a href="<?php echo esc_url($h_address_link); ?>" target="<?php echo esc_attr($h_address_link_target); ?>" class="h-item-link"></a>
                                                <?php endif; ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <?php if($h_btn_on == 'show' && !empty($h_btn_text)) : ?>
                                        <div class="ct-header-button-mobile">
                                            <a class="btn btn-default" href="<?php echo esc_url( $h_btn_url ); ?>" target="<?php echo esc_attr($h_btn_target); ?>"><?php echo esc_attr( $h_btn_text ); ?></a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </nav>
                            <div class="ct-header-meta">
                                <?php if($search_icon) : ?>
                                    <div class="header-right-item h-btn-search"><i class="fac fac-search"></i></div>
                                <?php endif; ?>
                                <?php if(class_exists('Woocommerce') && $cart_icon) : ?>
                                    <div class="header-right-item h-btn-cart">
                                        <i class="fac fac-shopping-basket"></i>
                                        <span class="widget_cart_counter_header"><?php echo sprintf (_n( '%d', '%d', WC()->cart->cart_contents_count, 'consultio' ), WC()->cart->cart_contents_count ); ?></span>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php if($h_btn_on == 'show' && !empty($h_btn_text)) : ?>
                        <div class="ct-header-button">
                            <a class="btn btn-default" href="<?php echo esc_url( $h_btn_url ); ?>" target="<?php echo esc_attr($h_btn_target); ?>"><?php echo esc_attr( $h_btn_text ); ?><i class="ct-arrow-right arrow-white"></i></a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <div id="ct-menu-mobile">
                <?php if(class_exists('Woocommerce') && $cart_icon) : ?>
                    <span class="btn-nav-cart"><i class="fac fac-shopping-basket"></i></span>
                <?php endif; ?>
                <span class="btn-nav-mobile open-menu">
                    <span></span>
                </span>
            </div>
        </div>
    </div>
</header>